%function [x_axis,y_axis,z_axis] = get_Vg_vs_B
%% set the default font size for all figure
set(0,'defaultAxesFontSize',20)

%% ask the user to load the file
uiwait(msgbox('Choose the file you want to analyze'))
[fileName,pathName,~] = uigetfile('*.dat', 'Open file .dat');

%% get the data by reading the file
file = importdata(fullfile(pathName,fileName));

%% ask for the gate voltage amplification
prompt_gate_voltage = 'enter the amplification for the gate voltage in Volts';
dlgtitle_gate_voltage = 'Input';
user_val_gate_voltage = inputdlg(prompt_gate_voltage,dlgtitle_gate_voltage);
gate_voltage_val = str2num(user_val_gate_voltage{1});

%% ask for the factor to convert Bx to Btot
prompt_Bx = 'enter the factor for converting Bx (T) to B (T)';
dlgtitle_Bx = 'Input';
user_val_Bx = inputdlg(prompt_Bx,dlgtitle_Bx);
Bx_val = str2num(user_val_Bx{1});

%% ask for the lockin amplification
prompt_Iac = 'enter lockin amplification in Amps';
dlgtitle_Iac = 'Input';
user_val_Iac = inputdlg(prompt_Iac,dlgtitle_Iac);
Iac_val = str2num(user_val_Iac{1});

%% ask for the measured lockin voltage amplification
prompt_Vmeas = 'enter the amplification for measured lockin voltage in Volts';
dlgtitle_Vmeas = 'Input';
user_val_Vmeas = inputdlg(prompt_Vmeas,dlgtitle_Vmeas);
Vmeas_val = str2num(user_val_Vmeas{1});

%% Reading the size of Vgate 
str_Vgate = char(file.textdata(6));
str_split = strsplit(str_Vgate);
size_Vgate = str2num(str_split{3});

%% Getting Vbias values
Vgate = file.data(1:size_Vgate,1)*gate_voltage_val;

%% Reading the size of Bx
str_Bx = char(file.textdata(12));
str_split_Bx = strsplit(str_Bx);
size_Bx = str2num(str_split_Bx{3});

%% Getting the Bx values
r=1;
for i=1:size_Bx
    Bx(i)=file.data(r,2);
    r=r+size_Vgate;
end

%% Getting measured Voltage values
s=1;
Vmeasure = zeros(size_Vgate,size_Bx);
for i=1:size_Bx
    Vmeasure(1:size_Vgate,i)=file.data(s:s+size_Vgate-1,6)*Vmeas_val;
    s=s+size_Vgate;
end

%% calculating the differential resistence in SI units
dVdI = Vmeasure/Iac_val;

figure;
x_axis = transpose(Vgate); %in Volts
y_axis = transpose(Bx/Bx_val);
z_axis = dVdI;
[X,Y] = meshgrid(x_axis,y_axis);
figure1 = pcolor(X,Y,transpose(dVdI));
hold on
set(figure1, 'EdgeColor', 'none');
cl=colorbar;
% max_value = max(max(transpose(dIdV(:,2:end-1))));
% caxis([0 max_value])
caxis([0 2*10^4])
cl.Label.String = 'R (\Ohms)';
xlabel('$V_{g}(V)$','Interpreter','latex')
ylabel('$B_{||}(T)$','Interpreter','latex');

%end